extern crate core;

use std::env;
use std::process;
use commandline::Config;

fn main() {
    let config = Config::new(env::args()).unwrap_or_else(|error| {
        eprintln!("parse arguments error: {}", error);
        process::exit(1);

    });

    println!("Search pattern: {}", config.pattern);
    println!("File name: {} ", config.filename);

    if let Err(e) = commandline::run(config) {
        eprintln!("run error: {}", e);
        process::exit(2);
    }
}
