# Contributing

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## We Develop with Github

We use github to host code, to track issues and feature requests, as well as accept pull requests.

## Pull Request Process

1. Fork the repo and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. Issue that pull request!

## Report bugs using Github's issues

We use GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/suquiya/combu/issues/new) it's that easy!

## Use a Consistent Coding Style

- Please see [rustfmt.toml]
  - Simply speaking, we use tab for indent.
- You can try running `rust fmt`.

## License

This project is licensed under [MIT license](./LICENSE)

<br>
<br>

## Information about construct for this CONTRIBUTING.md

This CONTRIBUTING.md is based on [seahorse's CONTRIBUTING.md](https://github.com/ksk001100/seahorse/blob/master/.github/CONTRIBUTING.md) - Copyright (c) 2019 Keisuke Toyota - licensed [MIT License](https://github.com/ksk001100/seahorse/blob/master/LICENSE).
