use rargsxd::*;
use colourizer::*;

fn main() {
    let mut parser = ArgParser::from_argv0();
    parser.author("BubbyRoosh")
        .info("stdin colourizer")
        .version("0.1.0")
        .args(vec!(
                Arg::bool("dontforce", false)
                    .short('d')
                    .help("Prevents colourizer from overriding the current input's styles"),

                Arg::bool("bold", false)
                    .short('b')
                    .help("Boldens the output"),
                Arg::bool("italics", false)
                    .short('i')
                    .help("Italicises the output"),
                Arg::bool("underline", false)
                    .short('u')
                    .help("Underlines the output"),
                Arg::bool("strike", false)
                    .short('s')
                    .help("Strikes through the output"),

                Arg::str("fg", "")
                    .short('c')
                    .help("Sets the foreground colour for the output"),
                Arg::str("bg", "")
                    .short('g') // b is already taken for **bold**
                    .help("Sets the background colour for the output"),

                Arg::str("rgb", "")
                    .help("Sets the colour for the output according to \"r;g;b\""),

        ))
        .parse();

    match run(parser) {
        Err(e) => println!("Error: {}", e),
        _ => {},
    }
}
