# Colourizer

Easily colourize command output


## Usage

Colourizer can either display text directly or get output from previous commands as a standalone program, or be used as a library for other crates.

## Standalone

### Direct

```sh
colourizer -b this will be bold!
colourizer -c red this will be red
colourizer --rgb "0;200;255" this will be bright blue
```

### Previous

```sh
echo this will be bold | colourizer -b
echo this will be red | cowsay | colourizer -c red
ping gnu.org | colourizer --rgb "0;200;255"
```

![ping](https://codeberg.org/BubbyRoosh/colour/raw/branch/main/ping.png)
![fortune](https://codeberg.org/BubbyRoosh/colour/raw/branch/main/fortune.png)

## Library

### Example usage

```rust
println!("{}", "this will be red and bold!".fgred().bold());
println!("{}", "this will be a bright blue".rgb("0;200;255"));
```
