use std::collections::HashMap;
use std::io::{self, BufRead};
use rargsxd::*;

fn main() {
    let mut parser = ArgParser::new("colour");
    parser.author("BubbyRoosh")
        .info("stdin colourizer")
        .version("0.1.0")
        .args(vec!(
                Arg::bool("bold", false)
                    .short('b')
                    .help("Boldens the output"),
                Arg::bool("italics", false)
                    .short('i')
                    .help("Italicises the output"),
                Arg::bool("underline", false)
                    .short('u')
                    .help("Underlines the output"),
                Arg::bool("strikethrough", false)
                    .short('s')
                    .help("Strikes through the output"),
                Arg::str("colour", "")
                    .short('c')
                    .help("Sets the colour for the output"),
                Arg::str("rgb", "")
                    .help("Sets the colour for the output according to \"r;g;b\""),
        ))
        .parse();

    // Moment
    let mut colours = HashMap::new();
    colours.insert("black".to_string(),     "\x1b[30m");
    colours.insert("red".to_string(),       "\x1b[31m");
    colours.insert("green".to_string(),     "\x1b[32m");
    colours.insert("yellow".to_string(),    "\x1b[33m");
    colours.insert("blue".to_string(),      "\x1b[34m");
    colours.insert("magenta".to_string(),   "\x1b[35m");
    colours.insert("cyan".to_string(),      "\x1b[36m");
    colours.insert("white".to_string(),     "\x1b[37m");

    let mut modifier = String::new();

    // Moment 2
    if parser.get_bool("bold")          {modifier += "\x1b[1m"}
    if parser.get_bool("italics")       {modifier += "\x1b[3m"}
    if parser.get_bool("underline")     {modifier += "\x1b[4m"}
    if parser.get_bool("strikethrough") {modifier += "\x1b[9m"}

    if let Some(code) = colours.get(&parser.get_str("colour")) {modifier += code}

    if parser.get_str("rgb") != "" {modifier += &format!("\x1b[38;2;{}m", parser.get_str("rgb"))}

    if parser.extra.len() > 0 {
        let string = parser.extra.join(" ");
        println!("{}{}", modifier, string);
    } else {
        let stdin = io::stdin();
        // Need to do this each line so that things like ping work
        for line in stdin.lock().lines() {
            let string = line.unwrap() + "\n";
            print!("{}{}", modifier, string);
        }
    }
}
