# collect-once-hashmap

This crate provides a type `CollectOnceHashMap` that can be collected from an
iterator just like a normal `std::collections::HashMap`, but it makes sure that
a duplicated key results in an error.

Example:

```rust
# use collect_once_hashmap::{CollectOnceHashMap, Error};
let hm = vec![(1, 1), (1, 2)]
    .into_iter()
    .collect::<CollectOnceHashMap<u8, u8>>()
    .into_inner();

assert!(hm.is_err());
assert!(std::matches!(hm, Err(Error::DuplicatedKey(1))));
```


# License

MPL-2.0
(c) Matthias Beyer
