use std::{thread, time};

#[macro_use]
extern crate text_io;

fn main() {
    println!("Do you want an explanation of this program?[y/n]");
    let explain: String = read!();
    if explain == "y"{
        println!("This program is based on a math problem called the collatz\
        conjecture, or 3x+1.\nIt is a set of two rules: a number is chosen. \
        If the number chosen is odd, then multiply by 3 and add 1.\nIf the \
        number is even, divide by 2.\nIn this way, each number will have a \
        unique pattern that it follows, but all numbers will end up as 1 \
        eventually.\nThen the calculation loops from 1, to 4, to 2, to 1 \
        indefinitely.");
        let s = time::Duration::from_secs(3);
        thread::sleep(s);
    } else if explain != "y" {
    }
    println!("Which number you wish to process?");
    let mut input: i64 = read!();
    println!("How much delay do you want between calculations(in seconds)?");
    let delinput: u64 = read!(); 
    let delay = time::Duration::from_secs(delinput);
    println!("You selected {}", input);
    while input != 1 {
        if input % 2 == 0 {
            println!("Number is even: {}, dividing by 2", input);
            input /= 2; 
            println!("Result is: {}", input);
            thread::sleep(delay);
        }
        else if input % 2 != 0 {
            println!("Number is odd: {}, multiplying by 3 then adding 1",input);
            input = input * 3 + 1;
            println!("Result is: {}", input);
            thread::sleep(delay);
        }
    }
    println!("The number became 1, and the loop was stopped because
    this calculation loops infinitely from 4-2-1");
}  
