use crate::expressions::LiteralExpression;
use crate::statements::{ExpressionStatement, LinkedStatement, Statement};
use crate::CodeBuffer;

#[test]
fn test() {
    let a: LiteralExpression = LiteralExpression::from("a");
    let b: LiteralExpression = LiteralExpression::from("b");
    let c: LiteralExpression = LiteralExpression::from("c");

    let mut linked: LinkedStatement = LinkedStatement::default();
    linked.link(Box::new(ExpressionStatement::from(a)));
    linked.link(Box::new(ExpressionStatement::from(b)));
    linked.link(Box::new(ExpressionStatement::from(c)));

    let mut code_buffer: CodeBuffer = CodeBuffer::default();
    linked.write(&mut code_buffer, 1);

    assert_eq!(code_buffer.peek(), "\ta\n\tb\n\tc\n");
}
