use crate::statements::Statement;
use crate::CodeBuffer;

/// Represents a linked statement.
pub struct LinkedStatement {
    statements: Vec<Box<dyn Statement>>,
}

impl Default for LinkedStatement {
    fn default() -> Self {
        Self {
            statements: Vec::with_capacity(8),
        }
    }
}

impl LinkedStatement {
    //! Link

    /// Links the statement.
    pub fn link(&mut self, statement: Box<dyn Statement>) {
        self.statements.push(statement);
    }
}

impl Statement for LinkedStatement {
    fn write(&self, b: &mut CodeBuffer, level: usize) {
        self.statements.iter().for_each(|s| s.write(b, level));
    }
}
