use crate::expressions::LiteralExpression;
use crate::statements::{ExpressionStatement, Statement};
use crate::CodeBuffer;

#[test]
fn test() {
    let literal: LiteralExpression = LiteralExpression::from("hello");
    let expression: ExpressionStatement<LiteralExpression> = ExpressionStatement::from(literal);
    let mut code_buffer: CodeBuffer = CodeBuffer::default();
    expression.write(&mut code_buffer, 1);
    assert_eq!(code_buffer.peek(), "\thello\n");
}
