use crate::statements::Statement;
use crate::CodeBuffer;

/// Represents an empty statement.
pub struct EmptyStatement {
    _phantom: (),
}

impl Default for EmptyStatement {
    fn default() -> Self {
        Self { _phantom: () }
    }
}

impl Statement for EmptyStatement {
    fn write(&self, b: &mut CodeBuffer, level: usize) {
        b.indent(level);
        b.end_line();
    }
}
