use crate::expressions::Expression;
use crate::CodeBuffer;

/// Represents a literal expression.
pub struct LiteralExpression {
    literal: String,
}

impl From<String> for LiteralExpression {
    fn from(literal: String) -> Self {
        Self { literal }
    }
}

impl From<&str> for LiteralExpression {
    fn from(literal: &str) -> Self {
        Self {
            literal: literal.to_string(),
        }
    }
}

impl Expression for LiteralExpression {
    fn write(&self, b: &mut CodeBuffer) {
        b.write(self.literal.as_str());
    }
}
