#![no_std]
#![feature(generic_associated_types)]
//! CoAP message implementation tools
//!
//! This crate contains utilities for creating own implementations of the [coap_message] traits, as
//! well as some basic implementations that may be useful for CoAP libraries.
//!
//! The implementations aim for being easy and straightforward. While they are largely usable on
//! embedded systems, it is expected that more optimized versions are used in that area when byte
//! comes to shove.

#[cfg(feature = "alloc")]
extern crate alloc;

pub mod option_extension;
pub mod option_iteration;

pub mod inmemory;

#[cfg(test)]
mod test;
