// Conveniently, that *is* available when tests are run
extern crate alloc;

#[test]
fn test_inmemory() {
    use coap_message::*;

    let message = crate::inmemory::Message::new(
        0x45,
        b"\xb5short\r\x03very-long-option\xe0\xfc\xd0\xffpayload",
    );

    assert!(message.code() == 0x45);

    let expected_options = [
        (11, b"short".to_vec()),
        (11, b"very-long-option".to_vec()),
        (65000, b"".to_vec()),
    ];
    let found_options: alloc::vec::Vec<_> = message
        .options()
        .map(|o| (o.number(), o.value().to_vec()))
        .collect();

    assert!(found_options == expected_options);

    assert!(message.payload() == b"payload");
}

// While it's technically a unit test, being so similar to the above makes it prefereable to have
// it here.
#[test]
fn test_encoding() {
    use crate::option_extension::encode_extensions;

    let example_options = [
        (11, &b"short"[..]),
        (11, &b"very-long-option"[..]),
        (65000, &b""[..]),
    ];

    let expected_encoding = b"\xb5short\r\x03very-long-option\xe0\xfc\xd0";

    let mut encoded = alloc::vec::Vec::new();
    let mut option = 0u16;
    for e in example_options.iter() {
        let delta = e.0 - option;
        option = e.0;
        encoded.extend_from_slice(encode_extensions(delta, e.1.len() as _).as_ref());
        encoded.extend_from_slice(e.1);
    }

    assert_eq!(&expected_encoding.as_ref(), &encoded);
}
