/// A minimal stateless testing CoAP server interface.
use coap_message::{MutableWritableMessage, ReadableMessage};

/// A CoAP request handler. This gets called by a CoAP server implementation that the handler is
/// assigned to; the server has the handler digest the request's data into a RequestData structure,
/// possibly calls estimate_length before allocating a response message, and then asks the handler to
/// populate the allocated response message with data persisted in the RequestData structure.
pub trait Handler {
    type RequestData;

    fn extract_request_data(&mut self, request: &impl ReadableMessage) -> Self::RequestData;
    fn estimate_length(&mut self, request: &Self::RequestData) -> usize;
    fn build_response(
        &mut self,
        response: &mut impl MutableWritableMessage,
        request: Self::RequestData,
    );
}
