# CNF - A "command not found" for [toolbx][1] users

This repository contains a "command not found" utility aimed at toolbox users.
Currently, it will:

- Forward commands not found on the host to a configurable toolbox via `toolbox
  run`
- Forward commands not found in a toolbox to the host via `flatpak-spawn --host`

This is done by hooking into the system shells using a specialized shell
function (refer to [`utils/profile.d/cnf.sh`][2] if you're curious).



## Installation

There is currently no automation for this, so you'll have to perform a few
steps by hand. To call `cnf` automatically whenever a command isn't found, you
must register appropriate shell hooks. This can be done in a number of ways:


### By copying `utils/profile.d/cnf.sh` to `/etc/profile.d/cnf.sh` from this repository

```shell
sudo cp utils/profile.d/cnf.sh /etc/profile.d/
```


### By manually pasting the hooks to your shells config file, e.g. `~/.bashrc`:

- If you use `bash` (or `dash`, and possibly others):

```shell
function command_not_found_handle {
    if command -v cnf 1>/dev/null; then
        cnf "$@"
    fi
}
```

- If you use `zsh`, place this in your `.zshrc`:

```shell
function command_not_found_handler {
    if command -v cnf 1>/dev/null; then
        cnf "$@"
    fi
}
```

If you don't know which shell you're currently using, the output of the
following command should tell you:

```shell
basename $(readlink -f /proc/$$/exe)
```

The latter approach has the added benefit that it also works inside any Toolbx
containers automatically. When you take the former approach, you'll have to do
the same inside your Toolbx containers, too! That is because Toolbx containers
don't share the hosts `/etc/profile.d/`.

Now restart your shell or open a new shell tab/window and try it out!



## Configuration

When you run this command for the first time, it will create a default
configuration file in `~/.config/cnf/cnf.toml`. The options should be
self-explanatory.


## CNF and sudo

When running commands with `sudo`, you will realize that the default "command
not found" text is displayed. That is because `sudo` performs its own
executable lookups, and if it can't find the command you were asking it to
execute, it will print this error and exit. There are two ways to "fix" this:


### The manual method

You directly call `cnf` with the command line that sudo couldn't find, like
this:

```shell
$ sudo foobar
sudo: foobar: command not found
$ cnf !!
```

The `!!` will be expanded by your shell to the last command you executed,
verbatim, including all of its arguments. This way you're forwarding the
command to cnf directly. *In other words: You're doing the shell hooks job, but
manually*.


### The automatic method

> **Replacing your sudo executable happens at your own responsibility. Please
> be careful very careful with this, as of currently this program has undergone
> minimal testing.**

Copy (or link) the `utils/sudo` from this repository next to some location on
your `$PATH`, like `$HOME/.local/bin`.

```shell
cp utils/sudo ~/.local/bin/
# Or link it like this:
# ln -s $PWD/utils/sudo ~/.local/bin/sudo
```

This wraps around sudo and forwards all commands unknown to sudo to `cnf`. All
other commands are forwarded to your systems `sudo` under `/usr/bin/sudo`.



[1]: https://containertoolbx.org/
[2]: utils/profile.d/cnf.sh
