pub mod config;
pub mod env;
pub mod error;
use crate::error::CnfError;

/// Main entrypoint.
///
/// Reads the command that wasn't found from `std::env::args` and tries to execute it somewhere
/// else depending on the current execution environment.
pub fn run() -> Result<(), CnfError> {
    let args: Vec<String> = std::env::args().skip(1).collect();

    if env::toolbx::detect() {
        env::toolbx::run(&args)
    } else if env::container::detect() {
        env::container::run(&args)
    } else if env::host::detect() {
        env::host::run(&args)
    } else {
        Err(CnfError::UnknownEnvironment)
    }
}
