//! # CNF Error Types
use thiserror::Error;

#[derive(Error, Debug)]
pub enum CnfError {
    /// Configuration file couldn't be read.
    #[error("Couldn't read configuration")]
    Config(String),

    /// Executable couldn't be found.
    #[error("Executable '{0}' couldn't be found")]
    NotFound(String),

    /// Execution environment is unknown.
    #[error("Unknown execution environment!")]
    UnknownEnvironment,

    /// Execution of a command in some environment failed.
    #[error("Executing '{env}' failed: '{error}'")]
    Execution {
        env: String,
        error: std::process::ExitStatus,
    },

    /// Transparent I/O error from stdlib.
    #[error(transparent)]
    ApplicationError(#[from] std::io::Error),

    /// Not implemented yet.
    #[error("Please implement '{0}' first!")]
    NotImplemented(String),
}
