# CNF - A "command not found" for [toolbx][1] users

This repository contains a "command not found" utility aimed at toolbox users.
Currently, it will:

- Forward commands not found on the host to a configurable toolbox via `toolbox
  run`
- Forward commands not found in a toolbox to the host via `flatpak-spawn --host`

This is done by hooking into the system shells using a specialized shell
function (refer to [`utils/profile.d/cnf.sh`][2] if you're curious).



## Installation

There is currently no automation for this, so you'll have to perform a few
steps by hand:

1. Copy (or link) `cnf` from the projects root directory to some location on
   your `PATH`.  I recommend `$HOME/.local/bin` for this, but anywhere on the
   path is fine.
2. To call `cnf` whenever a command isn't found, register the shell hooks by
   copying `utils/profile.d/cnf.sh` to `/etc/profile.d/cnf.sh`.

And this should be all you need. Here are the commands you probably have to run:

```shell
mkdir -p $HOME/.local/bin
cp cnf $HOME/.local/bin
# Or link it like this:
# ln -s $PWD/cnf ~/.local/bin/cnf
sudo cp utils/profile.d/cnf.sh /etc/profile.d/
```

Now restart your shell or open a new shell tab/window and try it out!


## Installation in toolbox

Toolbox containers don't share the hosts `/etc/profile.d`. Thus, for the
toolboxes to use `cnf`, one must manually append the contents of the
[`utils/profile.d/cnf.sh`][2] script to the used shells config file, usually
`.bashrc` or `.zshrc` or whatever you use.


## Configuration

There's a sample configuration file in this repository, `cnf.conf`. Copy this
to your `$HOME/.config/cnf.conf` to control in which of your many `toolboxes`
to run the commands if you're not happy with the default one. The file will
tell you more about itself.


## CNF and sudo

When running commands with `sudo`, you will realize that by default the default
"command not found" text is displayed. That is because `sudo` performs its own
executable lookups, and if it can't find the command you were asking it to
execute, it will print this error and exit. There are two ways to "fix" this:


### The manual method

You directly call `cnf` with the command line that sudo couldn't find, like
this:

```shell
$ sudo foobar
sudo: foobar: command not found
$ cnf !!
```

The `!!` will be expanded by your shell to the last command you executed,
verbatim, including all of its arguments. This way you're forwarding the
command to cnf directly. *In other words: You're doing the shell hooks job, but
manually*.


### The automatic method

> **Replacing your sudo executable happens at your own responsibility. Please
> be careful very careful with this, as of currently this program has undergone
> minimal testing.**

Copy (or link) the `utils/sudo` next to `cnf` to `$HOME/.local/bin`.

```shell
cp utils/sudo ~/.local/bin/
# Or link it like this:
# ln -s $PWD/utils/sudo ~/.local/bin/sudo
```

This wraps around sudo and forwards all commands unknown to sudo to `cnf`. All
other commands are forwarded to your systems `sudo` under `/usr/bin/sudo`.



[1]: https://containertoolbx.org/
[2]: utils/profile.d/cnf.sh
