//! Test susceptible-infected information spread.
use cnetworks::*;

#[test]
fn test_spread_random() {
    let mut net = Network::new(4, Model::None, Weight::default());
    net.link(0, 1).unwrap();
    net.link(1, 2).unwrap();
    net.link(2, 3).unwrap();
    let observers = si::spread_random(&net, 1);
    let mut infected = observers.as_map().keys().copied().collect::<Vec<usize>>();
    infected.sort_unstable();
    match observers.true_source() {
        0 => assert_eq!(infected, vec![0, 1]),
        1 => assert_eq!(infected, vec![0, 1, 2]),
        2 => assert_eq!(infected, vec![1, 2, 3]),
        3 => assert_eq!(infected, vec![2, 3]),
        _ => panic!("Root should not be {}", observers.true_source()),
    }
    let observers = si::spread_random(&net, 3);
    assert!(vec![0, 1, 2, 3].contains(&observers.true_source()));
    let mut infected = observers.as_map().keys().copied().collect::<Vec<usize>>();
    infected.sort_unstable();
    assert_eq!(infected, vec![0, 1, 2, 3])
}
