//! Test access to and validity of network properites.
use cnetworks::*;

#[test]
fn test_get() {
    let net = Network::new(3, Model::None, Weight::default());
    for i in 0..3 {
        assert!(net.exists(i));
    }
    for i in 3..100 {
        assert!(!net.exists(i));
    }
}

#[test]
fn test_degs() {
    let mut net = Network::new(3, Model::None, Weight::default());
    net.link(0, 1).unwrap();
    net.link(0, 2).unwrap();

    assert_eq!(net.deg_of(0).unwrap(), 2);
    assert_eq!(
        net.links_of(0).unwrap(),
        &vec![(1, 1.0), (2, 1.0)]
            .into_iter()
            .collect::<cn::IndexMap<_, _>>()
    );

    assert_eq!(net.deg_of(1).unwrap(), 1);
    assert_eq!(
        net.links_of(1).unwrap(),
        &vec![(0, 1.0)].into_iter().collect::<cn::IndexMap<_, _>>()
    );

    assert_eq!(net.deg_of(2).unwrap(), 1);
    assert_eq!(net.deg_total(), 4);
    assert_eq!(net.links().count(), 2);

    assert_eq!(net.deg_distr(), vec![(1, 2), (2, 1)].into_iter().collect());
}

#[test]
fn test_model() {
    let mut net = Network::new(3, Model::None, Weight::default());
    let name = "custom model name".to_string();
    net.set_model(&name);
    assert_eq!(net.model(), &Model::Custom(name.clone()));
    assert_eq!(net.model().as_str(), name);
}
