//! Internal module containing methods related to creating and removing links as well as
//! disconnecting entire nodes from the network.


/// `Weight` determines the weight of each link in the network (ie. the probability of the
/// infection spreading through it in each time step).
#[derive(Debug, Clone, PartialEq)]
pub enum Weight {
    /// The weight should be constant end equal to `c`. Keep in mind that 0 < c <= 1, the
    /// [`crate::Network::new()`] constructor **will panic** if that is not the case.
    Constant { c: f64 },
    /// A weight sampled uniformly from (0, 1).
    Uniform,
}

impl Default for Weight {
    /// Treated like [`Weight::Constant`] with `c = 1.0`.
    fn default() -> Self {
        Self::Constant { c: 1.0 }
    }
}

