use cnetworks::*;
use criterion::{criterion_group, criterion_main, Criterion};

pub fn criterion_benchmark(c: &mut Criterion) {
    for size in [100, 500, 1000] {
        let p = 8.0 / size as f64;
        let retain: Vec<usize> = (1..(0.2 * size as f64).round() as usize).collect();
        for (model_name, model) in [
            ("ba", Model::BA { m0: 4, m: 4 }),
            ("er", Model::ER { p, whole: true }),
        ] {
            let name = format!("pinto_{}_{}", model_name, size);
            c.bench_function(&name, |b| {
                let net = Network::with_seed(size, model.clone(), Weight::default(), &name);
                let mut observers = si::spread(&net, 0, 15).unwrap();
                observers.keep(&retain);
                b.iter(move || {
                    locate::lptv(&net, &observers).unwrap();
                })
            });
            let name = format!("pearson_{}_{}", model_name, size);
            c.bench_function(&name, |b| {
                let net = Network::with_seed(size, model.clone(), Weight::default(), &name);
                let mut observers = si::spread(&net, 0, 15).unwrap();
                observers.keep(&retain);
                b.iter(move || {
                    locate::pearson(&net, &observers).unwrap();
                })
            });
            let name = format!("full_{}_{}", model_name, size);
            c.bench_function(&name, |b| {
                let retain = retain.clone();
                let model = model.clone();
                let name = name.clone();
                b.iter(move || {
                    let net = Network::with_seed(size, model.clone(), Weight::default(), &name);
                    let mut observers = si::spread(&net, 0, 15).unwrap();
                    observers.keep(&retain);
                    locate::pearson(&net, &observers).unwrap();
                    locate::lptv(&net, &observers).unwrap();
                })
            });
        }
    }
}

criterion_group!(benches, criterion_benchmark);
criterion_main!(benches);
