use cnetworks::*;
use criterion::{criterion_group, criterion_main, Criterion};

pub fn criterion_benchmark(c: &mut Criterion) {
    for size in [100, 200, 500, 1000, 2000, 5000] {
        let p = 8.0 / size as f64;
        for (model_name, model) in [
            ("ba", Model::BA { m0: 4, m: 4 }),
            ("er", Model::ER { p, whole: true }),
        ] {
            let name = format!("new_{}_{}", model_name, size);
            c.bench_function(&name, |b| {
                b.iter(|| Network::with_seed(size, model.clone(), Weight::default(), &name))
            });
        }
    }
}

criterion_group!(benches, criterion_benchmark);
criterion_main!(benches);
