use cnetworks::cn;
use criterion::{black_box, criterion_group, criterion_main, Criterion};

pub fn criterion_benchmark(c: &mut Criterion) {
    for size in [1000, 2000, 5000] {
        c.bench_function(&format!("insert_hash_{}", size), |b| {
            b.iter(|| {
                let data = vec![1; size];
                let mut map = rustc_hash::FxHashMap::default();
                for i in 0..size {
                    map.insert(i, data.clone());
                }
            })
        });
        c.bench_function(&format!("insert_index_{}", size), |b| {
            b.iter(|| {
                let data = vec![1; size];
                let mut map = cn::IndexMap::default();
                for i in 0..size {
                    map.insert(i, data.clone());
                }
            })
        });
        c.bench_function(&format!("insert_btree_{}", size), |b| {
            b.iter(|| {
                let data = vec![1; size];
                let mut map = std::collections::BTreeMap::default();
                for i in 0..size {
                    map.insert(i, data.clone());
                }
            })
        });
        c.bench_function(&format!("insert_vec_{}", size), |b| {
            b.iter(|| {
                let data = vec![1; size];
                let mut map = cn::VecMap::default();
                for i in 0..size {
                    map.insert(i, data.clone());
                }
            })
        });
        c.bench_function(&format!("contains_hash_{}", size), |b| {
            let data = vec![1; size];
            let mut map = rustc_hash::FxHashMap::default();
            for i in 0..size {
                map.insert(i, data.clone());
            }
            b.iter(move || {
                map.contains_key(black_box(&20));
                map.contains_key(black_box(&(2 * size)));
            })
        });
        c.bench_function(&format!("contains_index_{}", size), |b| {
            let data = vec![1; size];
            let mut map = cn::IndexMap::default();
            for i in 0..size {
                map.insert(i, data.clone());
            }
            b.iter(move || {
                map.contains_key(black_box(&20));
                map.contains_key(black_box(&(2 * size)));
            })
        });
        c.bench_function(&format!("contains_btree_{}", size), |b| {
            let data = vec![1; size];
            let mut map = std::collections::BTreeMap::default();
            for i in 0..size {
                map.insert(i, data.clone());
            }
            b.iter(move || {
                map.contains_key(black_box(&20));
                map.contains_key(black_box(&(2 * size)));
            })
        });
        c.bench_function(&format!("contains_vec_{}", size), |b| {
            let data = vec![1; size];
            let mut map = cn::VecMap::default();
            for i in 0..size {
                map.insert(i, data.clone());
            }
            b.iter(move || {
                map.contains(black_box(20));
                map.contains(black_box(2 * size));
            })
        });
        c.bench_function(&format!("iter_hash_{}", size), |b| {
            let data = vec![1; size];
            let mut map = rustc_hash::FxHashMap::default();
            for i in 0..size {
                map.insert(i, data.clone());
            }
            b.iter(move || {
                map.iter().map(|(_, x)| black_box(x.len())).sum::<usize>();
            })
        });
        c.bench_function(&format!("iter_index_{}", size), |b| {
            let data = vec![1; size];
            let mut map = cn::IndexMap::default();
            for i in 0..size {
                map.insert(i, data.clone());
            }
            b.iter(move || {
                map.iter().map(|(_, x)| black_box(x.len())).sum::<usize>();
            })
        });
        c.bench_function(&format!("iter_btree_{}", size), |b| {
            let data = vec![1; size];
            let mut map = std::collections::BTreeMap::default();
            for i in 0..size {
                map.insert(i, data.clone());
            }
            b.iter(move || {
                map.iter().map(|(_, x)| black_box(x.len())).sum::<usize>();
            })
        });
        c.bench_function(&format!("iter_vec_{}", size), |b| {
            let data = vec![1; size];
            let mut map = cn::VecMap::default();
            for i in 0..size {
                map.insert(i, data.clone());
            }
            b.iter(move || {
                map.iter().map(|(_, x)| black_box(x.len())).sum::<usize>();
            })
        });
    }
}

criterion_group!(benches, criterion_benchmark);
criterion_main!(benches);
