use cnetworks::*;
use criterion::{criterion_group, criterion_main, Criterion};

pub fn criterion_benchmark(c: &mut Criterion) {
    for size in [100, 1000, 5000] {
        let p = 8.0 / size as f64;
        for (model_name, model) in [
            ("ba", Model::BA { m0: 4, m: 4 }),
            ("er", Model::ER { p, whole: true }),
        ] {
            let name = format!("distance_{}_{}", model_name, size);
            c.bench_function(&name, |b| {
                let net = Network::with_seed(size, model.clone(), Weight::default(), &name);
                b.iter(|| {
                    bfs::distance(&net, 1, size - 1).unwrap();
                })
            });
            let name = format!("path_{}_{}", model_name, size);
            c.bench_function(&name, |b| {
                let net = Network::with_seed(size, model.clone(), Weight::default(), &name);
                b.iter(|| {
                    bfs::path(&net, 1, size - 1).unwrap();
                })
            });
            let name = format!("tree_{}_{}", model_name, size);
            c.bench_function(&name, |b| {
                let net = Network::new(size, model.clone(), Weight::default());
                b.iter(|| {
                    bfs::tree(&net, 1).unwrap();
                })
            });
            let name = format!("active_tree_{}_{}", model_name, size);
            c.bench_function(&name, |b| {
                let net = Network::with_seed(size, model.clone(), Weight::default(), &name);
                b.iter(|| {
                    bfs::tree_active(&net, 1, &[size - 1, size - 2, size - 3, size - 4, size - 5])
                        .unwrap();
                })
            });
        }
    }
}

criterion_group!(benches, criterion_benchmark);
criterion_main!(benches);
