//! Test common network algorithms.
use cnetworks::*;

#[test]
fn test_clusters() {
    let mut net = Network::new(4, Model::None, Weight::default());
    net.link(0, 1).unwrap();
    net.link(1, 2).unwrap();
    assert_eq!(
        net.clusters(),
        vec![
            vec![0, 1, 2].into_iter().collect(),
            vec![3].into_iter().collect()
        ]
    );
    net.link(1, 3).unwrap();
    assert_eq!(net.clusters(), vec![vec![0, 1, 2, 3].into_iter().collect()]);
}

#[test]
fn test_stitch() {
    let mut net = Network::new(4, Model::None, Weight::default());
    net.stitch_together();
    for start in [0, 1, 2, 3] {
        let (_, unexpl) = bfs::explore(&net, start).unwrap();
        assert!(unexpl.is_empty());
    }
}
