//! Test susceptible-infected information spread.
use cnetworks::*;

#[test]
fn test_spread_random() {
    let mut net = Network::new(4, Model::None, Weight::default());
    net.link(0, 1).unwrap();
    net.link(1, 2).unwrap();
    net.link(2, 3).unwrap();
    let (root, observers) = si::spread_random(&net, 1);
    let mut infected = observers.as_map().keys().copied().collect::<Vec<usize>>();
    infected.sort_unstable();
    match root {
        0 => assert_eq!(infected, vec![1]),
        1 => assert_eq!(infected, vec![0, 2]),
        2 => assert_eq!(infected, vec![1, 3]),
        3 => assert_eq!(infected, vec![2]),
        _ => panic!("Root should not be {}", root),
    }
    let (root, observers) = si::spread_random(&net, 3);
    assert!(vec![0, 1, 2, 3].contains(&root));
    let mut infected = observers.as_map().keys().copied().collect::<Vec<usize>>();
    infected.sort_unstable();
    let mut cmp = vec![0, 1, 2, 3];
    cmp.retain(|x| *x != root);
    assert_eq!(infected, cmp)
}
