use cnetworks::*;
use criterion::{criterion_group, criterion_main, Criterion};

pub fn criterion_benchmark(c: &mut Criterion) {
    for size in [100, 200, 500, 1000] {
        let p = 8.0 / size as f64;
        let retain: Vec<usize> = (1..(0.2 * size as f64).round() as usize).collect();
        for (model_name, model) in [
            ("ba", Model::BA { m0: 10, m: 5 }),
            ("er", Model::ER { p, whole: true }),
        ] {
            c.bench_function(&format!("pinto_{}_{}", model_name, size), |b| {
                let net = Network::new(size, model.clone(), Weight::default());
                let mut observers = si::spread(&net, 0, 15).unwrap();
                observers.keep(&retain);
                b.iter(move || {
                    locate::lptv(&net, &observers).unwrap();
                })
            });
            c.bench_function(&format!("pearson_{}_{}", model_name, size), |b| {
                let net = Network::new(size, model.clone(), Weight::default());
                let mut observers = si::spread(&net, 0, 15).unwrap();
                observers.keep(&retain);
                b.iter(move || {
                    locate::pearson(&net, &observers).unwrap();
                })
            });
        }
    }
}

criterion_group!(benches, criterion_benchmark);
criterion_main!(benches);
