use cnetworks::*;
use criterion::{criterion_group, criterion_main, Criterion};

pub fn criterion_benchmark(c: &mut Criterion) {
    for size in [100, 200, 500, 1000, 2000, 5000] {
        let p = 8.0 / size as f64;
        for (model_name, model) in [
            ("ba", Model::BA { m0: 10, m: 5 }),
            ("er", Model::ER { p, whole: true }),
        ] {
            c.bench_function(&format!("new_{}_{}", model_name, size), |b| {
                b.iter(|| Network::new(size, model.clone(), Weight::default()))
            });
        }
    }
}

criterion_group!(benches, criterion_benchmark);
criterion_main!(benches);
