use cnetworks::*;
use criterion::{criterion_group, criterion_main, Criterion};

pub fn criterion_benchmark(c: &mut Criterion) {
    for size in [100, 1000, 5000] {
        let p = 8.0 / size as f64;
        for (model_name, model) in [
            ("ba", Model::BA { m0: 10, m: 5 }),
            ("er", Model::ER { p, whole: true }),
        ] {
            // Distance
            c.bench_function(&format!("distance_{}_{}", model_name, size), |b| {
                let net = Network::new(size, model.clone(), Weight::default());
                b.iter(|| {
                    bfs::distance(&net, 1, size - 1).unwrap();
                })
            });

            // Path
            c.bench_function(&format!("path_{}_{}", model_name, size), |b| {
                let net = Network::new(size, model.clone(), Weight::default());
                b.iter(|| {
                    bfs::path(&net, 1, size - 1).unwrap();
                })
            });

            // Tree
            c.bench_function(&format!("tree_{}_{}", model_name, size), |b| {
                let net = Network::new(size, model.clone(), Weight::default());
                b.iter(|| {
                    bfs::tree(&net, 1).unwrap();
                })
            });

            // Active tree
            c.bench_function(&format!("active_tree_{}_{}", model_name, size), |b| {
                let net = Network::new(size, model.clone(), Weight::default());
                b.iter(|| {
                    bfs::tree_active(&net, 1, &[size - 1, size - 2, size - 3, size - 4, size - 5])
                        .unwrap();
                })
            });
        }
    }
}

criterion_group!(benches, criterion_benchmark);
criterion_main!(benches);
