//! Test access to and validity of network properites.
use cnetworks::*;

#[test]
fn test_get() {
    let net = Network::new(3, Model::None, Weight::default());
    for i in 0..3 {
        assert!(net.get(i).is_ok());
    }
    for i in 3..100 {
        assert_eq!(net.get(i).unwrap_err(), CnErr::NoSuchNode(i));
    }
}

#[test]
fn test_degs() {
    let mut net = Network::new(3, Model::None, Weight::default());
    net.link(0, 1).unwrap();
    net.link(0, 2).unwrap();

    assert_eq!(net[0].deg(), &2);
    let map = vec![(1, 1.0), (2, 1.0)].into_iter().collect();
    assert_eq!(net[0].links(), &map);

    assert_eq!(net[1].deg(), &1);
    let map = vec![(0, 1.0)].into_iter().collect();
    assert_eq!(net[1].links(), &map);

    assert_eq!(net[2].deg(), &1);
    assert_eq!(net.total_deg(), 4);
    assert_eq!(net.edges(), 2);

    let map = vec![(1, 2), (2, 1)].into_iter().collect();
    assert_eq!(net.deg_distr(), map);
}


