/*!
This is a library of tools for creating and manipulating complex networks.

From [Wikipedia](https://en.wikipedia.org/wiki/Complex_network):

> Complex network is a graph-like structure with non-trivial characteristics.
> A complex network is a graph (network) with non-trivial topological features—features that do not
> occur in simple networks such as lattices or random graphs but often occur in networks representing
> real systems. The study of complex networks is a young and active area of scientific
> research inspired largely by empirical findings of real-world networks such
> as computer networks, biological networks, technological networks, brain networks, climate networks
> and social networks.
*/

extern crate rand;
extern crate rand_xoshiro;
extern crate serde;
extern crate rustc_hash;
extern crate rand_seeder;

mod algorithms;
mod error;
mod network;
mod node;
mod flag;

pub use algorithms::*;
pub use error::CnErr;
pub use network::*;
pub use node::*;
pub use flag::*;
