//! This module contains the error enum.

/// `Error` is used to signify a recoverable error.
#[derive(Debug, PartialEq)]
pub enum CNErr {
    NoSuchNode(usize),
    BadWeight(f64),
    LinkToSelf(usize),
    BadProbability(f64),
}

impl CNErr {
    /// Used to panic and display a meaningful message when the error is non-recoverable.
    pub(crate) fn panic(&self) {
        let message = match self {
            CNErr::NoSuchNode(i) => format!("No such node {}", i),
            CNErr::BadWeight(w) => format!("Link weight cannot be {}", w),
            CNErr::LinkToSelf(i) => format!("Attempted linking node {} to itself", i),
            CNErr::BadProbability(p) => format!("Probability cannot be {}", p),
        };
        std::panic::panic_any(message);
    }
}
