use std::collections::HashMap;

/// `Node` is a single vertex in the graph-like data structure.
#[derive(Debug, Clone)]
pub(super) struct Node {
    /// The index is the node's name, identifying it in the network. It is also the index in the
    /// `nodes` vector of parent `Network`.
    pub(super) index: usize,
    /// Map of (link target, link weight) pairs specifying the connections with other nodes in the
    /// parent network.
    pub(super) links: HashMap<usize, f64>,
    /// The infected flag, used to determine information spread in the parent network.
    pub(super) infected: bool,
}

impl Node {
    /// Return the vertex degree of node (ie. the number of closest neighbors).
    pub(super) fn deg(&self) -> usize {
        self.links.len()
    }
}
