//! # cmice, CLI mice
//! This is a command line dice expression evaluator.
//! The output format is unstable, because
//! [`mice`](https://crates.io/crates/mice) is unstable.
use ::mice::backend_support::TyTarget::Mir::Stack as MirStack;
use ::clap::{Parser, Subcommand};

#[derive(Parser)]
#[clap(author, version, about, long_about = None)]
#[clap(propagate_version = true)]
#[clap(infer_subcommands = true)]
struct Cli {
    #[clap(subcommand)]
    command: Commands,
}

#[derive(Subcommand)]
enum Commands {
    /// Launch the dice rolling REPL.
    Repl,
    /// Launch the debugger.
    #[clap(hide = true)]
    Mdb,
}

fn main() {
    let cli = Cli::parse();

    match cli.command {
        Commands::Repl => {
            use ::std::io::BufRead;
            let stdin = ::std::io::stdin();
            for line in stdin.lock().lines() {
                let line = line.unwrap();
                let program = match ::mice::parse::parse_expression::<MirStack>(line.as_bytes()) {
                    Ok((_input, (_tokens, proggy))) => proggy,
                    Err(_) => {
                        if line.len() > 0 {
                            println!("That's an invalid dice expression.");
                        }
                        continue
                    }
                };
                let result = ::mice::mir::stack::interpret(&program, u64::MAX, &mut ::rand::thread_rng());
                match result {
                    Ok(output) => println!("{}", ::mice::mir::fmt::mbot_format_default(&output.output, output.total)),
                    Err(e) => eprintln!("{:?}", e),
                }
            }
        },
        Commands::Mdb => {
            todo!("implement the debugger REPL, but better this time");
            // let result = ::mice::interp::interpret(&mut ::rand::thread_rng(), &program);
            // match result {
            //     Ok(output) => println!("{}", ::mice::interp::fmt::mbot_format_default(program.terms(), &output)),
            //     Err(e) => eprintln!("{:?}", e),
            // }
            // let old_stack_program = ::mice::stack::compile(&program);
            // let mir = ::mice::mir::lower(&program).unwrap();
            // println!("{}", ::mice::mir::dot(&mir));
            // // println!("Mir Interp: {:?}", ::mice::mir::interp::interpret(&mir));
            // let stack_program = ::mice::mir::stack::lower(&mir);
            // // println!("Old Stack Program Size: {}, New Stack Program Size: {}",
            // //          old_stack_program.len_bytes(), stack_program.len());
            // // println!("MIR Program Size: {}", mir.size());
            // println!("{:?}", stack_program);
            // println!("Stack VM Disassembly");
            // println!("--------------------");
            // println!("{}", stack_program.disasm());
            // println!("Stack VM Execution");
            // let mut stack_machine = ::mice::mir::stack::Machine::new(&stack_program, 0);
            // let _ = dbg!(stack_machine.debugger(&mut ::rand::thread_rng()));
            // mir.print_externals();
        }
    }
}
