# clu
[![license-badge](https://img.shields.io/crates/l/clu.svg)](https://opensource.org/licenses/MIT)
[![build](https://github.com/phR0ze/clu/workflows/build/badge.svg?branch=main)](https://github.com/phR0ze/clu/actions)
[![codecov](https://codecov.io/gh/phR0ze/clu/branch/main/graph/badge.svg?token=LZHXZNZcRR)](https://codecov.io/gh/phR0ze/clu)
[![crates.io](https://img.shields.io/crates/v/clu.svg)](https://crates.io/crates/clu)
[![Minimum rustc](https://img.shields.io/badge/rustc-1.42+-lightgray.svg)](https://github.com/phR0ze/gory#rustc-requirements)

***Automation for the Arch Linux ecosystem***

### Quick links
* [Usage](#usage)
  * [Rustc requirments](#rustc-requirements)
* [Contribute](#contribute)
  * [Git-Hook](#git-hook)
* [License](#license)
  * [Contribution](#contribution)
* [Backlog](#backlog)
* [Changelog](#changelog)

## Usage <a name="usage"/></a>

#### Requires rustc >= 1.42 <a name="rustc-requirements"/></a>
This minimum rustc requirement is driven by the
[tracing\_subscriber](https://docs.rs/tracing-subscriber/0.2.15/tracing_subscriber) requirements

TBD

## Contribute <a name="Contribute"/></a>
Pull requests are always welcome. However understand that they will be evaluated purely on whether
or not the change fits with my goals/ideals for the project.

### Git-Hook <a name="git-hook"/></a>
Enable the git hooks to have automatic version increments
```bash
cd ~/Projects/clu
git config core.hooksPath .githooks
```

## License <a name="license"/></a>
This project is licensed under either of:
 * MIT license [LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT
 * Apache License, Version 2.0 [LICENSE-APACHE](LICENSE-APACHE) or http://www.apache.org/licenses/LICENSE-2.0

### Contribution <a name="contribution"/></a>
Unless you explicitly state otherwise, any contribution intentionally submitted for inclusion in
this project by you, as defined in the Apache-2.0 license, shall be dual licensed as above, without
any additional terms or conditions.

---

## Backlog <a name="backlog"/></a>

## Changelog <a name="changelog"/></a>
