use std::io::Write;
use std::io::Read;
use cloudflare_soos as soos;

fn main() {
    if let Err(e) = run() {
        let _ = write!(std::io::stderr().lock(), "error: {}\n", e);
        std::process::exit(1);
    }
}

fn run() -> Result<(), soos::Error> {
    let input_file = if let Some(input_path) = std::env::args().nth(1) {
        std::fs::read(input_path)?
    } else {
        let mut buf = Vec::with_capacity(0xFFFF);
        std::io::stdin().lock().read_to_end(&mut buf)?;
        buf
    };

    let (pri, pri_change) = soos::Scans::from_file(&input_file)?.cf_priority_change_headers()?;
    write!(std::io::stdout().lock(), "{}\n{}", pri, pri_change)?;
    Ok(())
}
