use std::io::*;

pub trait ReadBytesExt: Read {
    #[inline(always)]
    fn read_u8(&mut self) -> Result<u8> {
        let mut buf = 0u8;
        self.read_exact(std::slice::from_mut(&mut buf))?;
        Ok(buf)
    }

    #[inline(always)]
    fn read_u16_be(&mut self) -> Result<u16> {
        let mut buf = [0u8; 2];
        self.read_exact(&mut buf)?;
        Ok(u16::from_be_bytes(buf))
    }
}

impl<T: Read> ReadBytesExt for T {}
