use cloudflare_soos as soos;
use std::env;
use std::fs;
use std::process;
use soos::jpeg;

fn usage() -> ! {
    eprintln!("usage: scan image.jpg");
    process::exit(1)
}

fn main() {
    let mut args = env::args().skip(1);
    let input_path = args.next().unwrap_or_else(|| usage());
    let input_file = fs::read(input_path).expect("The specified input file could not be opened");

    let mut decoder = jpeg::Decoder::new(input_file.as_slice());
    let markers = decoder.decode().expect("Decode error");
    for m in markers {
        match m.marker {
            jpeg::MarkerData::Scan(s) => {
                println!("{}: {}-{}, {}, {};", s.component_indices.into_iter().map(|c| c.to_string()).collect::<Vec<_>>().join(","),
                    s.spectral_selection.start(), s.spectral_selection.end(),
                    s.successive_approximation_high, s.successive_approximation_low,
                );
            },
            _ => {},
        }
    }
}
