use cloudflare_soos as soos;
use std::env;
use std::fs;
use std::process;
use std::path::Path;
use std::path::PathBuf;

fn usage() -> ! {
    eprintln!("usage: {} image.jpg", env::args().next().as_ref().map(|s| s.as_str()).unwrap_or("chop"));
    process::exit(1)
}

fn main() {
    let mut args = env::args_os().skip(1);
    let input_path = PathBuf::from(args.next().unwrap_or_else(|| usage()));
    let input_file = fs::read(&input_path).expect("The specified input file could not be opened");

    let scans = soos::Scans::from_file(&input_file).expect("Scan failed");

    println!("{:#?}", scans);

    write_up_to(&input_path, &input_file, "0-meta", scans.metadata_end);
    write_up_to(&input_path, &input_file, "1-render", scans.frame_render_start);
    write_up_to(&input_path, &input_file, "2-first_scan", scans.first_scan_end);
    write_up_to(&input_path, &input_file, "3-good_scan", scans.good_scan_end);
}

fn write_up_to(src_path: &Path, data: &[u8], chunk_name: &str, len: Option<usize>) {
    let src_ext = src_path.extension().and_then(|e| e.to_str()).unwrap_or("jpeg");
    let src_stem = src_path.file_stem().unwrap().to_str().unwrap();
    let dst_path = src_path.with_file_name(format!("{}-{}.{}", src_stem, chunk_name, src_ext));

    match len {
        Some(len) => { std::fs::write(&dst_path, &data[..len]).expect(&format!("Can't write output file to {}", dst_path.display())) },
        None => { let _ = std::fs::remove_file(dst_path); },
    }
}
