use cloudflare_soos as soos;
use std::env;
use std::fs;
use std::process;

fn usage() -> ! {
    eprintln!("usage: {} image.jpg", env::args().next().as_ref().map(|s| s.as_str()).unwrap_or("cf-priority"));
    process::exit(1)
}

fn main() {
    let mut args = env::args().skip(1);
    let input_path = args.next().unwrap_or_else(|| usage());
    let input_file = fs::read(input_path).expect("The specified input file could not be opened");

    let scans = soos::Scans::from_file(&input_file).expect("Scan failed");

    println!("{:#?}", scans);
    let (pri, pri_change) = scans.cf_priority_change_headers().unwrap();
    println!("cf-priority: {}", pri);
    println!("cf-priority-change: {}", pri_change);
}
