# Scan Offsets of Scans

Progressive image parser for [HTTP/2 parallel progressive streaming](https://blog.cloudflare.com/parallel-streaming-of-progressive-images/) feature.

Computes optimal offsets for the `cf-priority-change` header to render images progressively with a "preview" and "good enough" stages. In JPEG it tries to render DC channels only (libjpeg-turbo has a special support for nicely blurring the DC-only stage) and then prioritize sending enough data for the image look fully loaded.

In case of GIF animations it prioritizes sending the first frame only. In interlaced PNG it roughly guesses progressive scans. For non-progressive images it tries to send image dimensions before any other data to aid page layout and (improves Cumulative Layout Shift (CLS) metric).

### Building and usage

[Install Rust](https://rustup.rs/) 1.52 or later, and run:

```sh
cargo install cloudflare-soos
```

```sh
soos-cf-priority image.jpg
```

This will print to stdout Cloudflare's `cf-priority` (first line) and `cf-priority-change` (second line) headers with breakpoints for the `image.jpg` file, an error to stderr. The image is read from stdin if not path is specified. This tool requires progressive JPEG files, and doesn't do anything for baseline JPEG or other formats.

The same can be done programmatically by [using this crate as a library](https://docs.rs/cloudflare-soos) and calling `soos::Scans::from_file(jpeg_bytes)?.cf_priority_change_headers()?`.

You can also build for WASM with `rustup target add wasm32-unknown-unknown; cargo build --release --target=wasm32-unknown-unknown` or use [wasm-pack](https://lib.rs/crates/wasm-pack).

### Example tools

```sh
cargo run --example cf-priority -- image.jpg
cargo run --example scan -- image.jpg
```

These tools show debug information used to generate the HTTP priority headers.

### Credits

JPEG parsing is based on [jpeg-decoder](https://lib.rs/jpeg-decoder) by Ulf Nilsson. GIF parsing is from [Piston GIF](https://lib.rs/crates/gif) crate.
