use surf::http::Method;

use crate::framework::async_api;
use crate::framework::endpoint::Endpoint;
use crate::framework::ApiResultTraits;
use async_trait::async_trait;
use surf::http::Result;

pub struct MockApiClient {}

// This endpoint does nothing. Designed for use with MockApiClient.
pub struct NoopEndpoint {}

impl Endpoint<NoopResult> for NoopEndpoint {
    fn method(&self) -> Method {
        Method::Get
    }
    fn path(&self) -> String {
        "no/such/path/".to_owned()
    }
}

#[derive(Deserialize, Debug)]
pub struct NoopResult {}
impl ApiResultTraits for NoopResult {}

fn mock_response() -> surf::Error {
    surf::Error::new(
        surf::http::StatusCode::InternalServerError,
        anyhow::Error::msg("This is a mocked failure response".to_owned()),
    )
}

#[async_trait]
impl async_api::AsyncApiClient for MockApiClient {
    async fn request<ResultType, QueryType, BodyType>(
        &self,
        _endpoint: &(dyn Endpoint<ResultType, QueryType, BodyType> + Send + Sync),
    ) -> Result<ResultType> {
        Err(mock_response())
    }
}
