# Contributing to CloudEvents SDK Rust

This page contains information about reporting issues, how to suggest changes as
well as the guidelines we follow for how our documents are formatted.

## Table of Contents

- [Reporting an Issue](#reporting-an-issue)
- [Preparing the environment](#preparing-the-environment)
- [Suggesting a Change](#suggesting-a-change)

## Reporting an Issue

To report an issue, or to suggest an idea for a change that you haven't had time
to write-up yet, open an [issue](https://github.com/cloudevents/sdk-rust/issues). It
is best to check our existing
[issues](https://github.com/cloudevents/sdk-rust/issues) first to see if a similar
one has already been opened and discussed.

## Preparing the environment

In order to start developing this project, 
you need to install the Rust tooling using [rustup](https://rustup.rs/).

### Development commands

To build the project:

```sh
cargo build --all-features --all
```

To run all tests:

```sh
cargo test --all-features --all
```

To build and open the documentation:

```sh
cargo doc --all-features --lib --open
```

Before performing the PR, once you have committed all changes, run:

```sh
cargo fix --all && cargo fmt --all
```

And commit the changed files. These commands will reorganize imports and format the code.

## Suggesting a change

To suggest a change to this repository, submit a
[pull request](https://github.com/cloudevents/spec/pulls)(PR) with the complete
set of changes you'd like to see. See the
[Spec Formatting Conventions](#spec-formatting-conventions) section for the
guidelines we follow for how documents are formatted.

Each PR must be signed per the following section.

### Sign your work

The sign-off is a simple line at the end of the explanation for the patch. Your
signature certifies that you wrote the patch or otherwise have the right to pass
it on as an open-source patch. The rules are pretty simple: if you can certify
the below (from [developercertificate.org](http://developercertificate.org/)):

```
Developer Certificate of Origin
Version 1.1

Copyright (C) 2004, 2006 The Linux Foundation and its contributors.
1 Letterman Drive
Suite D4700
San Francisco, CA, 94129

Everyone is permitted to copy and distribute verbatim copies of this
license document, but changing it is not allowed.

Developer's Certificate of Origin 1.1

By making a contribution to this project, I certify that:

(a) The contribution was created in whole or in part by me and I
    have the right to submit it under the open source license
    indicated in the file; or

(b) The contribution is based upon previous work that, to the best
    of my knowledge, is covered under an appropriate open source
    license and I have the right under that license to submit that
    work with modifications, whether created in whole or in part
    by me, under the same open source license (unless I am
    permitted to submit under a different license), as indicated
    in the file; or

(c) The contribution was provided directly to me by some other
    person who certified (a), (b) or (c) and I have not modified
    it.

(d) I understand and agree that this project and the contribution
    are public and that a record of the contribution (including all
    personal information I submit with it, including my sign-off) is
    maintained indefinitely and may be redistributed consistent with
    this project or the open source license(s) involved.
```

Then you just add a line to every git commit message:

    Signed-off-by: Joe Smith <joe.smith@email.com>

Use your real name (sorry, no pseudonyms or anonymous contributions.)

If you set your `user.name` and `user.email` git configs, you can sign your
commit automatically with `git commit -s`.

Note: If your git config information is set properly then viewing the `git log`
information for your commit will look something like this:

```
Author: Joe Smith <joe.smith@email.com>
Date:   Thu Feb 2 11:41:15 2018 -0800

    Update README

    Signed-off-by: Joe Smith <joe.smith@email.com>
```

Notice the `Author` and `Signed-off-by` lines match. If they don't your PR will
be rejected by the automated DCO check.
