use super::common;
use serde::{Deserialize, Serialize};
use structopt::StructOpt;

#[derive(Debug, StructOpt, Clone, PartialEq, Eq, PartialOrd, Ord, Serialize, Deserialize)]
pub struct Add {
    #[structopt(flatten)]
    pub content_args: common::MandatoryContentArgs,
    #[structopt(flatten)]
    pub desc_args: common::DescriptionArgs,
    #[structopt(flatten)]
    pub proj_args: common::ProjectArgs,
    #[structopt(flatten)]
    pub label_args: common::LabelArgs,
    #[structopt(flatten)]
    pub prio_args: common::PriorityArgs,
    #[structopt(flatten)]
    pub due_args: common::DueDateArgs,
}

impl crate::Runs<super::Task> for Add {
    fn run(task: &mut super::Task) {
        match &task.command {
            Some(command) => match command {
                super::Command::Add(_) => todo!(),
                _ => panic!("`Add::run` called for another `Command`. Tf?"),
            },
            None => panic!("`Task::commands::Add::run` called with no `Command` as arg"),
        }
    }
}

#[derive(Debug, StructOpt, Clone, PartialEq, Eq, PartialOrd, Ord, Serialize, Deserialize)]
pub struct Close {
    #[structopt(flatten)]
    pub id_args: common::IdArgs,
}

impl crate::Runs<super::Task> for Close {
    fn run(task: &mut super::Task) {
        match &task.command {
            Some(command) => match command {
                super::Command::Close(_) => todo!(),
                _ => panic!("`Close::run` called for another `Command`. Tf?"),
            },
            None => panic!("`Task::commands::Close::run` called with no `Command` as arg"),
        }
    }
}

#[derive(Debug, StructOpt, Clone, PartialEq, Eq, PartialOrd, Ord, Serialize, Deserialize)]
pub struct Open {
    #[structopt(flatten)]
    pub id_args: common::IdArgs,
}

impl crate::Runs<super::Task> for Open {
    fn run(task: &mut super::Task) {
        match &task.command {
            Some(command) => match command {
                super::Command::Open(_) => todo!(),
                _ => panic!("`Open::run` called for another `Command`. Tf?"),
            },
            None => panic!("`Task::commands::Open::run` called with no `Command` as arg"),
        }
    }
}

#[derive(Debug, StructOpt, Clone, PartialEq, Eq, PartialOrd, Ord, Serialize, Deserialize)]
pub struct Update {
    #[structopt(flatten)]
    pub id_args: common::IdArgs,
    #[structopt(flatten)]
    pub content_args: common::ContentArgs,
    #[structopt(flatten)]
    pub desc_args: common::DescriptionArgs,
    #[structopt(flatten)]
    pub proj_args: common::ProjectArgs,
    #[structopt(flatten)]
    pub label_args: common::LabelArgs,
    #[structopt(flatten)]
    pub prio_args: common::PriorityArgs,
    #[structopt(flatten)]
    pub due_args: common::DueDateArgs,
}

impl crate::Runs<super::Task> for Update {
    fn run(task: &mut super::Task) {
        match &task.command {
            Some(command) => match command {
                super::Command::Update(_) => todo!(),
                _ => panic!("`Update::run` called for another `Command`. Tf?"),
            },
            None => panic!("`Task::commands::Update::run` called with no `Command` as arg"),
        }
    }
}

#[derive(Debug, StructOpt, Clone, PartialEq, Eq, PartialOrd, Ord, Serialize, Deserialize)]
pub struct Delete {
    #[structopt(flatten)]
    pub id_args: common::IdArgs,
}

impl crate::Runs<super::Task> for Delete {
    fn run(task: &mut super::Task) {
        match &task.command {
            Some(command) => match command {
                super::Command::Delete(_) => todo!(),
                _ => panic!("`Delete::run` called for another `Command`. Tf?"),
            },
            None => panic!("`Task::commands::Delete::run` called with no `Command` as arg"),
        }
    }
}

#[derive(Debug, StructOpt, Clone, PartialEq, Eq, PartialOrd, Ord, Serialize, Deserialize)]
pub struct Copy {
    #[structopt(flatten)]
    pub id_args: common::IdArgs,
    #[structopt(flatten)]
    pub content_args: common::ContentArgs,
    #[structopt(flatten)]
    pub proj_args: common::ProjectArgs,
}

impl crate::Runs<super::Task> for Copy {
    fn run(task: &mut super::Task) {
        match &task.command {
            Some(command) => match command {
                super::Command::Copy(_) => todo!(),
                _ => panic!("`Copy::run` called for another `Command`. Tf?"),
            },
            None => panic!("`Task::commands::Copy::run` called with no `Command` as arg"),
        }
    }
}
