use super::common;
use schemars::JsonSchema;
use serde::{Deserialize, Serialize};
use structopt::StructOpt;

#[derive(Debug, StructOpt, Clone, PartialEq, Eq, PartialOrd, Ord, Serialize, Deserialize)]
pub struct Project {
    /* Get project args: */
    #[structopt(flatten)]
    pub id_args: common::OptionalIdArgs,

    /* Subcommands: */
    #[structopt(subcommand)]
    pub command: Option<Command>,
}

#[derive(
    Debug, Default, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Serialize, Deserialize, JsonSchema,
)]
pub struct Model<'proj> {
    pub id: Option<&'proj str>,
    pub name: Option<&'proj str>,
    /**
    A numeric ID representing the color of the project icon; refer to the id column in the colors
    guide for more info; https://developer.todoist.com/guides/#colors
    */
    pub color: Option<u32>,
    pub favorite: Option<bool>,
    /** Whether the project is Inbox (read-only, true or otherwise this property is not sent). */
    pub inbox_project: Option<bool>,
    pub url: Option<&'proj str>,
    // IGNORED: parent_id; order; comment_count; shared; team_inbox; sync_id
}

#[derive(Debug, StructOpt, Clone, PartialEq, Eq, PartialOrd, Ord, Serialize, Deserialize)]
pub enum Command {
    /** Filterable list of projects */
    List {
        #[structopt(flatten)]
        name_args: common::NameArgs,
    },
    /** Add a new project */
    Add {
        #[structopt(flatten)]
        name_args: common::MandatoryNameArgs,
    },
    /** Update an existing project */
    Update {
        #[structopt(flatten)]
        id_args: common::IdArgs,
        #[structopt(flatten)]
        name_args: common::NameArgs,
    },
    /** Delete a project */
    Delete {
        #[structopt(flatten)]
        id_args: common::IdArgs,
    },
    /** List all tasks for a given project */
    All {},
}
