use super::common;
use schemars::JsonSchema;
use serde::{Deserialize, Serialize};
use structopt::StructOpt;

#[derive(Debug, StructOpt, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub struct Label {
    /* Get label args: */
    #[structopt(flatten)]
    pub id_args: common::OptionalIdArgs,

    /* Subcommands: */
    #[structopt(subcommand)]
    pub command: Command,
}

#[derive(
    Debug, Default, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Serialize, Deserialize, JsonSchema,
)]
pub struct Model<'label> {
    pub id: Option<usize>,
    pub name: Option<&'label str>,
    /**
    A numeric ID representing the color of the project icon; refer to the id column in the colors
    guide for more info; https://developer.todoist.com/guides/#colors
    */
    pub color: Option<u32>,
    pub favorite: Option<bool>,
}

/** Option of `Action`s to perform on this variant of `Item`. */
#[derive(Debug, StructOpt, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub enum Command {
    /** Filterable list of labels */
    List {
        #[structopt(flatten)]
        name_args: common::NameArgs,
    },
    /** Add a new label */
    Add {
        #[structopt(flatten)]
        name_args: common::MandatoryNameArgs,
    },
    /** Update an existing label */
    Update {
        #[structopt(flatten)]
        id_args: common::IdArgs,
        #[structopt(flatten)]
        name_args: common::NameArgs,
    },
    /** Delete a label */
    Delete {
        #[structopt(flatten)]
        id_args: common::IdArgs,
    },
    /** List all tasks for any given label(s) */
    All {},
}
