use structopt::StructOpt;

fn main() {
    let args = Wrapper::from_args();
    match args.app {
        App::Todoist(mut app) => todoist::Todoist::run(&mut app),
    }
}

/* Wrapper for global args. */
#[derive(Debug, StructOpt)]
struct Wrapper {
    #[structopt(long, global = true)]
    debug: bool,
    #[structopt(subcommand)]
    app: App,
}

/* Apps go here. */
#[derive(Debug, StructOpt)]
enum App {
    Todoist(todoist::Todoist),
}
mod todoist;

trait Runs<Args>
where
    Args: StructOpt,
{
    /** Statically call `run` and pass relevant `args`. We want to allow the args to be mutated. */
    fn run(args: &mut Args);
}

/* Everything below could likely be migrated to an external lib. */
mod file_system;
