use reqwest::blocking::RequestBuilder;
use reqwest::Error;
use reqwest::Method;
use reqwest::Response;
use std::borrow::Cow;

pub(crate) trait Endpoint {
    fn method(&self) -> Method;
    fn url(&self) -> Cow<'static, str>;
    // fn params(&self) -> QueryParams {
    //     QueryParams::default()
    // }
}

pub(crate) trait Client {
    fn make_request(&self, request: RequestBuilder) -> Result<Response, Error>;
}

pub(crate) trait Query<T, C>
where
    C: Client,
{
    fn query(&self, client: &C) -> Result<T, Error>;
}
